<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Config extends Model 
{

    protected $table = 'configs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('default_currency_id', 'default_country_id', 'slug', 'uv', 'tva', 'cash', 'transfer_send_valid_message', 'transfer_send_end_message', 'exchange_send_valid_message', 'exchange_send_end_message', 'default_box_alert_threshold', 'default_agency_alert_threshold', 'default_open_hour', 'default_close_hour', 'status', 'use_mobile_pay');
    protected $visible = array('default_currency_id', 'default_country_id', 'slug', 'uv', 'tva', 'cash', 'transfer_send_valid_message', 'transfer_send_end_message', 'exchange_send_valid_message', 'exchange_send_end_message', 'default_box_alert_threshold', 'default_agency_alert_threshold', 'default_open_hour', 'default_close_hour', 'status', 'use_mobile_pay');

    public function defaultCurrency()
    {
        return $this->belongsTo('App\Models\Currency', 'default_currency_id');
    }

    public function defaultCountry()
    {
        return $this->belongsTo('App\Models\Country', 'default_country_id');
    }

}